import express,{Router, Request, Response} from 'express';
import {Project} from '../models/Project';
import {myDataSource} from '../app-data-source';
import { Member, MemberRole } from '../models/Member';
import { auth, authAdminProject } from '../helpers';

const router:Router = express.Router();
const dataSource = myDataSource;
 

router.get('/',async (req:Request, res:Response): Promise<Response>=> {
    const projects:Project[] = await dataSource.manager.find(Project)
    return res.send({projects})
})

/**get projects were user is member, by user token */
router.get('/my',auth, async (req:Request, res:Response): Promise<Response>=> {
    const user = req.body.user
    const rawProjects = await dataSource
    .createQueryBuilder() 
    .from(Project, "project")
    .select(["project.id"])
    .leftJoinAndSelect('project.members', 'member')
    .loadRelationCountAndMap('project.tasks', 'project.tasks')
    .leftJoinAndSelect('member.user', 'user' )
    .where('member.userId = :userId',{userId:user.id})
    .getMany()
    const projectIds = []
    if (rawProjects.length>0){
        for(let project of rawProjects){
            projectIds.push(project.id
                ) 
        }
    }
    const projects = await dataSource
    .createQueryBuilder()
    .from(Project, "project")
    .select(["project"])
    .leftJoinAndSelect('project.members', 'member')
    .loadRelationCountAndMap('project.tasks', 'project.tasks')
    .leftJoinAndSelect('member.user', 'user')
    .where('project.id IN(:...projectIds)', {projectIds})
    .getMany()
    return res.send({projects})
})




/**create new project */
router.post('/',auth, async (req:Request, res:Response): Promise<Response> => {
    
    if (!req.body) return res.status(400).send({Message:'problem in incoming req.body'})
    const {user, title,color}= req.body;

         try{
            const projectCheck = await dataSource
            .getRepository(Project)
            .find({
                where:{
                    title:title
                }
         })
        if(projectCheck.length>0) {return res.status(400).send({message:"suchc Project already exists"})}

        } catch(e){
            return res.status(502).send({message:(e as Error).message})
        }
  

    try{
        const member:Member = new Member;
        member.user= user;
        member.roleProject= MemberRole.ADMIN;
        await member.save();
        const project : Project= new Project()
        project.title = title;
        project.color = color; 
        project.members=[member]
        await project.save()
        return res.send({project})
    } catch(e) {
        return res.status(502).send({message:(e as Error).message})
    }

})
/**get project with all FK & tasks with all FK, by project ID */
router.get("/:id",async (req:Request, res:Response): Promise<Response> => {
    const project = await dataSource
    .createQueryBuilder()
    .select("project")
    .from(Project, "project")
    .leftJoinAndSelect('project.members', 'member')
    .leftJoinAndSelect('member.user', 'user' )
    .where("project.id = :id", { id: req.params.id })
    .getOne()
    if (!project) return res.status(404).send({Message:'no info on this project'})
    const tasks = await dataSource.getRepository('Task')
    .find(
        {
            relations:{
                executor:true,
                author:true,
            },
            where:{
                project:{
                    id:req.params.id
                }
            }
        }
    )
    return res.send({project, tasks})
})

/** Delete project by project ID*/
router.delete('/',authAdminProject,async (req: Request, res: Response):Promise<Response>=>{
    const {projectId} = req.body; 
    await myDataSource
    .createQueryBuilder()
    .delete()
    .from(Project)
    .where("id = :id", { id: projectId })
    .execute()
    return res.send({message: 'Project deleted successfully'})

})

/** Get projects were user is admin, by user ID*/

router.get('/user/:userId', async (req : Request, res : Response): Promise<Response>=>{
    const userId:string = req.params.userId
    const userProjects = await dataSource
    .createQueryBuilder()
    .select('project')
    .from(Project, "project")
    .where("project.admin = :id", { id: userId })
    .getMany();
    return res.send({userProjects})
})

/** Add user to specific project  */

router.post('/add-user/', authAdminProject, async (req: Request, res: Response):Promise<Response>=>{
    const {userId, projectId, roleProject} = req.body;
    const newMember:Member = new Member();
    try{
    newMember.user= userId;
    newMember.project=projectId
    newMember.roleProject=roleProject
    await newMember.save()
    return res.send({newMember})
    } catch(e){ 
        return res.send({message:"add user to project failed" })
    }
    
})


/** Remove user from specific project by userId  */

router.delete('/remove-user/:userId', authAdminProject,async (req: Request, res: Response):Promise<Response>=> {
    const {projectId} = req.body;
    const {userId }=req.params;

    try{        
        const projectMember = await dataSource
                .getRepository(Member)
                .findOne({
                    relations:{
                        user:true,
                        project:true
                    },
                    where:{
                        user:{
                            id:userId
                        },
                        project:{
                            id:projectId
                        }
                    }
                })
                if(!projectMember) return res.status(404).send({message:"this member is not present"})
                await Member.delete({id:projectMember.id})
            return res.send({message:"User removed from project successfully" })
            } catch(e){
                return res.send({message:'Failed to remove user from project'})
            }
    
}) 


/**change rights of user inside of project by admin, recieve userId, new roleProject  */

router.put('/change-project-role/:userId',authAdminProject,  async (req: Request, res: Response):Promise<Response|void> =>{
    const {userId}= req.params
    const {projectId, newRoleProject} =req.body

    const member = await dataSource
    .createQueryBuilder()
    .select("member")
    .from(Member, "member")
    .leftJoinAndSelect("member.user","user")
    .leftJoinAndSelect('member.project', 'project' )
    .where("user.id = :userId", { userId })
    .andWhere("project.id=:projectId",{projectId})
    .getOne()
    if(!member) return res.status(404).send({Message:'user and project are not relevant'})
    try{
        member.roleProject = newRoleProject
        await member.save()

    } catch(e){
        return res.send({message:"failed to change role"})
    }
    return res.send({message:"User's new role ", newRoleProject})
    
})

export default router;
