import { Card, CardActions, CardContent, Grid, IconButton, Tooltip } from "@mui/material";
import { Link } from "react-router-dom";
import ArrowForwardIcon from "@mui/icons-material/ArrowForward";
import { useDispatch, useSelector } from "react-redux";
import DeleteIcon from "@mui/icons-material/Delete";

const ProjectMembersItem = ({ displayName, roleProject, id, roleProjectOfAuthor }) => {
    console.log(displayName)
    const dispatch = useDispatch();
    const user = useSelector(state => state.users)
    console.log(user)
    const { projects, project } = useSelector(state => state.projects);

    return <>
        <Grid item xs={12} sm={12} md={6} lg={4}>
            <Card>
                <CardContent>
                    <strong>
                        <br></br>
                        {displayName}
                    </strong>
                    <strong>
                        <br></br>
                        роль: {roleProject}
                    </strong>
                    <strong>

                        {roleProjectOfAuthor === "admin" ?
                            (<strong>
                                <Tooltip title="Удалить">
                                    <IconButton
                                        onClick={(id) => {
                                            // deleteHandle(task.id);
                                        }}
                                    >
                                        <DeleteIcon style={{ marginTop: "-5px" }} />
                                    </IconButton>
                                </Tooltip>
                            </strong>) : null}
                    </strong>
                </CardContent>
            </Card>
        </Grid>
    </>
};

export default ProjectMembersItem;
