import { Button, TextField } from "@mui/material";
import { memo } from "react";
import { priorities } from "../../../constants";
import CustomSelect from '../../UI/СustomSelect/СustomSelect'


function CalendarModalContent({ title, onChangeCurrentTaskHandler, description, priority, sendNewTaskHandler, deleteTaskHandler, startHour, endHour }) {
  return (<>
    <TextField
      id="task-description-title"
      value={title}
      label="Название"
      variant="outlined"
      sx={{ marginBottom: '30px' }}
      name='title'
      onChange={(e) => { onChangeCurrentTaskHandler(e) }}
    />
    <TextField
      id="task-description"
      multiline
      rows={4}
      value={description}
      label="Описание"
      variant="outlined"
      sx={{ marginBottom: '30px' }}
      name='description'
      onChange={(e) => { onChangeCurrentTaskHandler(e) }}
    />
    <CustomSelect
      defaultValue={null}
      value={priority}
      name={'priority'}
      variant={'outlined'}
      onChange={(e) => { onChangeCurrentTaskHandler(e) }}
      label={'Приоритет'}
      id={'priority-type'}
      items={priorities}
    />
    <div style={{ display: 'flex', gap: '20px', margin: '20px 0' }}>
      <TextField
        id="task-startHour"
        value={startHour}
        label="От"
        variant="outlined"
        name='startHour'
        onChange={(e) => { onChangeCurrentTaskHandler(e) }}
      />
      <TextField
        id="task-endHour"
        value={endHour}
        label="До"
        variant="outlined"
        name='endHour'
        onChange={(e) => { onChangeCurrentTaskHandler(e) }}
      />
    </div>
    <div style={{ display: 'flex', gap: '20px', margin: '10px 0' }}>
      <Button id='test_button_save_task' onClick={sendNewTaskHandler}>Сохранить</Button>
      <Button onClick={deleteTaskHandler}>Удалить</Button>
    </div>
  </>);
}

export default memo(CalendarModalContent);