import {useNavigate} from "react-router-dom";
import {useDispatch, useSelector} from "react-redux";

import { useEffect } from "react";
import ProjectForm from "../../components/ProjectComponents/ProjectForm/ProjectForm";
import { createMember, createProject, fetchMembers, fetchProjects } from "../../store/actions/projectsActions";
import MemberForm from "../../components/MemberForm/MemberForm";

const NewMember = ({members}) => {
    const dispatch = useDispatch();
    const projects = useSelector(state => state.projects.projects);
    const navigate = useNavigate();

    const onSubmit = async (memberData) => {
        await dispatch(createMember(memberData, navigate));
        navigate("/projects/" + memberData.projectId)
        console.log("memberData ", memberData)

    };

    // useEffect(()=> {
    //     dispatch(fetchMembers());
    // }, [dispatch])

    return (
        <>
            <MemberForm members={members} onSubmit={onSubmit} />
        </>
    );
};

export default NewMember;