import * as React from "react";
import PropTypes from "prop-types";
import Box from "@mui/material/Box";
import TableCell from "@mui/material/TableCell";
import TableHead from "@mui/material/TableHead";
import TableRow from "@mui/material/TableRow";
import TableSortLabel from "@mui/material/TableSortLabel";
import { visuallyHidden } from "@mui/utils";

const headCells = [
  {
    id: "id",
    numeric: true,
    disablePadding: true,
    label: "",
    canSort: true,
  },
  {
    id: "priority",
    numeric: false,
    disablePadding: true,
    label: "Приоритет",
    canSort: true,
  },
  {
    id: "createdAt",
    numeric: true,
    disablePadding: false,
    label: "Дата создания",
    canSort: true,
  },
  {
    id: "title",
    numeric: true,
    disablePadding: false,
    label: "Заголовок",
    canSort: true,
  },
  {
    id: "projectName",
    numeric: true,
    disablePadding: false,
    label: "Проект",
    canSort: true,
  },
  {
    id: "authorDisplayName",
    numeric: true,
    disablePadding: false,
    label: "Автор",
    canSort: true,
  },

  {
    id: "dateTimeStart",
    numeric: true,
    disablePadding: false,
    label: "Дата и время выполнения",
    canSort: false,
  },
  {
    id: "dateTimeDeadLine",
    numeric: true,
    disablePadding: false,
    label: "Дедлайн",
    canSort: true,
  },
  {
    id: "accomplish",
    numeric: true,
    disablePadding: false,
    label: "Статус",
    canSort: true,
  },
  {
    id: "change",
    numeric: false,
    disablePadding: false,
    label: "",
    canSort: false,
  },
  {
    id: "delete",
    numeric: false,
    disablePadding: false,
    label: "",
    canSort: false,
  },
];

export default function EnhancedTableHead({
  order,
  orderBy,
  rowCount,
  onRequestSort,
}) {

  return (
    <TableHead>
      <TableRow>
        {headCells.map((headCell) => (
          <TableCell
            key={headCell.id}
            align={"left"}
            padding={headCell.disablePadding ? "none" : "normal"}
            sortDirection={
              headCell.canSort && orderBy === headCell.id ? order : false
            }
            style={{ paddingLeft: "0" }}
          >
            {headCell.canSort ? (
              <TableSortLabel
                active={orderBy === headCell.id}
                direction={orderBy === headCell.id ? order : "asc"}
                onClick={() => onRequestSort(headCell.id)}
              >
                {headCell.label}
                {orderBy === headCell.id ? (
                  <Box component="span" sx={visuallyHidden}>
                    {order === "desc"
                      ? "sorted descending"
                      : "sorted ascending"}
                  </Box>
                ) : null}
              </TableSortLabel>
            ) : (
              <span>{headCell.label}</span>
            )}
          </TableCell>
        ))}
      </TableRow>
    </TableHead>
  );
}

EnhancedTableHead.propTypes = {
  onRequestSort: PropTypes.func.isRequired,
  order: PropTypes.oneOf(["asc", "desc"]).isRequired,
  orderBy: PropTypes.string.isRequired,
  rowCount: PropTypes.number.isRequired,
};
