import ArrowDecrementButton from '../../../../UI/ArrowDecrementButton/ArrowDecrementButton';
import ArrowIncrementButton from '../../../../UI/ArrowIncrementButton/ArrowIncrementButton';
import { Box } from '@mui/system';
import { Typography } from '@mui/material';
import { memo } from 'react';



function WeekCalendarHeaderInfo({ decrementWeek, incrementWeek, weekInfo }) {

  return (
    <>
      <Box sx={{ width: '40%', marginBottom: '15px' }}>
        <h2>Цель недели: Наладить режим сна</h2>
        <Box sx={{ display: 'flex', alignItems: 'center' }}>
          <ArrowDecrementButton
            onClick={() => { decrementWeek() }}
          />
          <Typography
            variant="h6"
            sx={{
              flexBasis: '250px',
              display: 'flex',
              justifyContent: 'center',
            }}
          >
            {weekInfo}
          </Typography>
          <ArrowIncrementButton
            onClick={() => { incrementWeek() }}
          />
        </Box>
      </Box>
    </>
  );
}

export default memo(WeekCalendarHeaderInfo);