﻿using System;
using System.Collections.Generic;
using System.Linq;
using Lesson49.Models;
using Lesson49.Models.Data;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Internal;

namespace Lesson49.Controllers
{
    public class PhonesController : Controller
    {
        private MobileContext _db;

        public PhonesController(MobileContext db)
        {
            _db = db;
        }

        // GET
        public IActionResult Index() //Phones/Create
        {
            List<Phone> phones = _db.Phones
                .Include(p => p.Brand)
                .ToList();
            return View(phones);
        }

        [HttpGet]
        public IActionResult Add()//Phones/Add
        {
            var brands = _db.Brands
                .ToDictionary(b => b.Id, b => b.Name);
            ViewData["brands"] = brands;
            return View();
        }

        [HttpPost]
        public IActionResult Add(Phone phone)
        {
            if (phone != null)
            {
                _db.Phones.Add(phone);
                _db.SaveChanges();
            }

            return RedirectToAction("Index");
        }
    }
}