﻿using Lesson49.Models;
using Lesson49.Models.Data;
using Microsoft.AspNetCore.Mvc;

namespace Lesson49.Controllers
{
    public class OrdersController : Controller
    {
        private MobileContext _db;

        public OrdersController(MobileContext db)
        {
            _db = db;
        }

        // GET
        [HttpGet]
        public IActionResult Add(int phoneId)
        {
            Order order = new Order();
            order.PhoneId = phoneId;
            return View(order);
        }

        [HttpPost]
        public IActionResult Add(Order order)
        {
            
            if (order != null)
            {
                _db.Orders.Add(order);
                _db.SaveChanges();
            }

            return RedirectToAction("Index", "Phones");
        }
    }
}