﻿using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Hosting;

namespace Lesson49.Controllers
{
    public class HomeController : Controller
    {
        private readonly IHostEnvironment _appEnvironment;

        public HomeController(IHostEnvironment appEnvironment)
        {
            _appEnvironment = appEnvironment;
        }

        public IActionResult Index(int? id)
        {
            return Json(id);
        }
        
        public User GetUser(int id)//Home/GetString
        {
            User u = new User("John", 20,1);
            User u2 = new User("John", 20,2);
            User u3 = new User("John", 20,3);
            User u4 = new User("John", 20,4);
            List<User> users = new List<User>() {u, u2, u3, u4};
            return users.FirstOrDefault(u => u.Id == id);
        }

        public IActionResult DownloadFile()
        {
            string filePath = Path.Combine("~\\Files", "book.txt");
            return File(filePath, "application/pdf", "newBook.txt");
        }
        
        public FileResult GetFileStream()
        {
            string path = Path.Combine(_appEnvironment.ContentRootPath, "Files/book.pdf");
            FileStream stream = new FileStream(path, FileMode.Open);
            string fileType = "application/pdf";
            string fileName = "book.txt";
            return File(stream, fileType, fileName);
        }


        public User CreateUser(User user)
        {
            return user;
        }

        [NonAction]
        public bool GetBool()
        {
            return true;
        }

        public IActionResult GetSum(int num1, int num2)
        {
            return Json(num1+num2);
        }
        
        
        
    }

    public class User
    {
        public int Id { get; set; }
        public string Name { get; set; }
        public int Age { get; set; }

        public User(string name, int age, int id)
        {
            Id = id;
            Name = name;
            Age = age;
        }

        public User()
        {
        }
        
    }
}