import {configureStore} from '@reduxjs/toolkit';
import userSlice from './users/users.slice';
import { postsSlice } from './posts/posts.slice';
import commentsSlice from './comments/comments.slice';

export const store = configureStore({
	reducer: {
		user: userSlice,
		posts: postsSlice.reducer,
		comments: commentsSlice
	},
});

export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;
export type AppStore = ReturnType<typeof store.getState>;
export type AppState = ReturnType<typeof store.getState>;
