import React, {useEffect, useState} from 'react';
import {Navigate, useNavigate} from 'react-router-dom';
import IUser from '../interfaces/IUser';
import {useAppDispatch, useAppSelector} from '../store/hooks';
import {createUser, loginUser} from '../store/users/users.slice';

const Login = () => {
	const dispatch = useAppDispatch();
	const navigate = useNavigate();
	const [user, setUser] = useState({} as IUser);
	const {userLoggedIn} = useAppSelector((state) => state.user);

	const handleRegister = async () => {
		await dispatch(createUser(user));
	};

	const handleUserInput = (e: React.ChangeEvent<HTMLInputElement>) => {
		setUser((prevState) => ({...prevState, [e.target.name]: e.target.value}));
	};

	const handleSubmit = async (e: React.ChangeEvent<HTMLFormElement>) => {
		e.preventDefault();

		await dispatch(loginUser(user));
	};

	if (userLoggedIn) {
		return <Navigate to={'/'} />;
	}

	return (
		<div className="w-full max-w-xs m-auto h-screen mt-[200px]">
			<form
				onSubmit={handleSubmit}
				className="bg-white shadow-md rounded px-8 pt-6 pb-8 mb-4"
			>
				<div className="mb-4">
					<label
						className="block text-gray-700 text-sm font-bold mb-2"
						htmlFor="username"
					>
						Username
					</label>
					<input
						onChange={handleUserInput}
						className="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline"
						id="username"
						type="text"
						placeholder="Username"
						name="username"
					/>
				</div>
				<div className="mb-6">
					<label
						className="block text-gray-700 text-sm font-bold mb-2"
						htmlFor="password"
					>
						Password
					</label>
					<input
						onChange={handleUserInput}
						className="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 mb-3 leading-tight focus:outline-none focus:shadow-outline"
						id="password"
						type="password"
						placeholder="Password"
						name="password"
					/>
				</div>
				<div className="flex items-center justify-between">
					<button
						className="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline"
						type="submit"
					>
						Sign In
					</button>
					<a
						className="inline-block align-baseline font-bold text-sm text-blue-500 hover:text-blue-800"
						href="#"
						type="button"
						onClick={handleRegister}
					>
						Register
					</a>
				</div>
			</form>
			<p className="text-center text-gray-500 text-xs">
				&copy;2020 Acme Corp. All rights reserved.
			</p>
		</div>
	);
};

export default Login;
