import {FunctionComponent, ReactElement, useEffect} from 'react';
import {shallowEqual, useDispatch} from 'react-redux';
import {useAppDispatch, useAppSelector} from '../store/hooks';
import {getUser} from '../store/users/users.slice';
import { useSelector } from 'react-redux';
import PostsList from '../components/PostList/PostList';
import { AppState } from '../store/store';
import { getPosts } from '../store/posts/posts.slice';

const HomePage: FunctionComponent = (): ReactElement => {
	
	const dispatch = useAppDispatch();
	const {posts} = useSelector((state: AppState) => state.posts, shallowEqual)
	const { user } = useSelector((state: AppState) => state.user,shallowEqual);

	useEffect(() => {
		const token = window.sessionStorage.getItem('token');
		if (token) {
			dispatch(getUser(token));
		
		}
	},[])
	useEffect(() => {
		dispatch(getPosts())
		
	},[])


	if (!user) {
		return <div>Loading...</div>; 
	  }

	return (
		<div className="bg-gray-50 dark:bg-gray-900 h-screen w-full container mx-auto">
			<PostsList posts={posts}/>
		
		</div>
	);
};

export default HomePage;
