import React, { FunctionComponent, ReactElement } from "react";
import IPost from "../../interfaces/IPost";
import Post from "../Post/Post";

interface IPostListProps {
    posts: IPost[]
}
const PostsList: FunctionComponent<IPostListProps> = (posts): ReactElement => {
    return (
        <div className="flex justify-center items-center">
      <div >
        {posts.posts.length ? (
          posts.posts.map((p) => {
            return <Post key={p._id} post={p} />;
          })
        ) : (
          <h1 className="text-center text-2xl font-bold mt-10">
            No Posts
          </h1>
        )}
      </div>
    </div>
    )
}

export default PostsList