import React, { FunctionComponent, MutableRefObject, ReactElement, useRef } from "react";
import IPost from "../../interfaces/IPost";
import defaultImage from '../../assets/default-image.jpg'
import { useNavigate } from "react-router-dom";

interface IPostProps {
    post: IPost;
}

const Post: FunctionComponent<IPostProps> = ({ post }): ReactElement => {
    const navigate = useNavigate()

    const toIdPost = (id: string) => {
        navigate({pathname: `/posts/${id}`})
    }

    return (
        <div onClick={() => toIdPost(post._id)} className=" rounded-lg shadow-md flex flex-col justify-between mb-5">
            <img
                className="object-cover w-full h-80 rounded-t-lg"
                src={`${import.meta.env.VITE_BASE_URL}uploads/${post.image}`}
                alt={post.title}
                onError={(e) => {
                    e.currentTarget.src = defaultImage;
                }}
            />
            <div className="p-4">
                <p className="text-gray-400 text-xs"> {new Date(post.datetime).toLocaleString('en-US', {
                    year: 'numeric',
                    month: '2-digit',
                    day: '2-digit',
                    hour: 'numeric',
                    minute: 'numeric',
                    second: 'numeric'
                })}</p>
                <p className="text-lg font-bold mb-2">{post.title}</p>
                <p className="text-sm mb-2">{post.description}</p>
                <p className="text-sm mb-2 text-gray-400">Посмотреть все комментарии</p>
            </div>
            <div className="border-t p-4">

            </div>
        </div>
    )
}

export default Post