import React, { FunctionComponent, ReactElement } from 'react';
import { NavLink, Outlet } from 'react-router-dom';
import { useAppDispatch, useAppSelector } from '../store/hooks';
import { setInitialUser } from '../store/users/users.slice';

const Layout: FunctionComponent = (): ReactElement => {
	const { user } = useAppSelector((state) => state.user);
	const dispatch = useAppDispatch();
	return (
		<div className="bg-gray-100 flex ml">
			<div className="w-1/6">
				<div className="container mx-auto ml-5	 py-4">
					<p className="text-lg font-medium mb-8">Forum</p>
					{!user.username ? (
						<div>
							<NavLink className="text-gray-700 hover:text-gray-900" to={'register'}>
								Register
							</NavLink>
						</div>
					) : (
						<div className="flex   flex-col">
							<NavLink className=" mb-4" to={'/'}>Home
							</NavLink>
							<p className="text-gray-700 mb-4">
								Hello
								<span className="text-indigo-600"> {user.username}!</span>
							</p>
							<NavLink className=" mb-4" to={'create'}>Add new Post
							</NavLink>
							<NavLink
								onClick={() => {
									window.sessionStorage.setItem('token', '');
									dispatch(setInitialUser());
								}}
								to={'/'}
								className="text-gray-700 hover:text-gray-900"
							>
								Log out
							</NavLink>
						</div>
					)}
				</div>

			</div>
			<div className="w-3/4">
				<div className="container mx-auto py-8">
					<Outlet />
				</div>
			</div>
		</div>
	);
};

export default Layout;
