import {
	FunctionComponent,
	ReactElement,
	useState,
	ChangeEvent,
	FormEvent,
} from 'react';
import {AppDispatch, AppState} from '../../store/store';
import {shallowEqual, useDispatch} from 'react-redux';
import IPostDto from '../../interfaces/IPostDto';
import {createPost} from '../../store/posts/posts.slice';
import {useSelector} from 'react-redux';

const CreatePost: FunctionComponent = (): ReactElement => {
	const {user} = useSelector((state: AppState) => state.user, shallowEqual);
	const dispatch: AppDispatch = useDispatch();

	const [post, setPost] = useState<IPostDto>({
		title: '',
		description: '',
		image: undefined,
	});

	const [fileName, setFileName] = useState<string>('');

	const inputHandler = (e: ChangeEvent<HTMLInputElement>): void => {
		setPost((prevState) => {
			return {...prevState, [e.target.name]: e.target.value};
		});
	};

	const inputFileHandler = (e: ChangeEvent<HTMLInputElement>): void => {
		setPost((prevState) => {
			return {
				...prevState,
				image: e.target.files ? e.target.files[0] : undefined,
			};
		});
		setFileName(
			e.target.files && e.target.files[0] ? e.target.files[0].name : ''
		);
	};
	const submitHandler = (e: FormEvent) => {
		e.preventDefault();
		const formData = new FormData();
		formData.append('title', post.title);
		formData.append('description', post.description);
		formData.append('user', user._id);
		dispatch(createPost(formData));
		setPost(post);
	};
	return (
		<div className="bg-gray-100 p-4">
			<form
				onSubmit={submitHandler}
				className="flex gap-4 flex-col items-center"
			>
				<input
					name="title"
					type="text"
					placeholder="Title"
					value={post.title}
					onChange={inputHandler}
					className="border border-gray-400 rounded-md px-3 py-2 focus:outline-none focus:border-blue-400 flex-grow"
				/>

				<input
					name="description"
					type="text"
					placeholder="Description"
					value={post.description}
					onChange={inputHandler}
					className="border border-gray-400 rounded-md px-3 py-2 focus:outline-none focus:border-blue-400 flex-grow"
				/>

				<label className="relative flex items-center justify-center bg-white border border-gray-400 rounded-md px-4 py-2 cursor-pointer">
					<input
						type="file"
						name="image"
						onChange={inputFileHandler}
						className="hidden"
					/>
					<span className="text-gray-500 font-medium mr-2">CHOOSE FILE</span>
					<span className="text-gray-500 font-medium">{fileName}</span>
				</label>

				<button className="bg-blue-500 hover:bg-blue-600 text-white py-2 px-4 rounded-md">
					SEND
				</button>
			</form>
		</div>
	);
};

export default CreatePost;
