import ICommentProps from "./ICommentProps";
import React, { FunctionComponent, ReactElement } from "react";
import { AppDispatch } from "../../store/store";
import { useDispatch } from "react-redux";
import './Comment.css'
import { deleteCommentById, getCommentsByPost } from "../../store/comments/comments.slice";

const Comment: FunctionComponent<ICommentProps> = (props): ReactElement => {
    const dispatch: AppDispatch = useDispatch()

    const deleteComment = () => {
        try {
            dispatch(deleteCommentById(props.comments._id))
        } finally {
            dispatch(getCommentsByPost(props.params_id))
        }   
    }
    
    return (
        <div className="comment_block">
            <span>{props.comments.user} wrote: {props.comments.comment}</span>
            <button className="comment_btn" onClick={deleteComment}>Delete</button>
        </div>
    )
}

export default Comment