import { EStatuses } from "../enums/EStatuses";
import IComment from "../interfaces/IComment";
import ICommentDto from "../interfaces/ICommentDto";
import IResponse from "../interfaces/IResponse";
import { instance } from "./instance";

class CommentApi {
    public getCommentsByPost = async (post_id: string): Promise<IResponse<IComment[] | undefined>> => {
        try {
            const response = await instance.get(`/comments?post_id=${post_id}`)
            return response.data
        } catch(err: unknown) {
            const error = err as Error
            const response: IResponse<undefined> = {
                status: EStatuses.NOT_OK,
                message: error.message,
                result: undefined
            }
            return response
        }
    }

    public createComment = async (commentDto: ICommentDto): Promise<IResponse<IComment | undefined>> => {
        try {
            const response = await instance.post(`/comments`, commentDto)
            return response.data
        } catch(err: unknown) {
            const error = err as Error
            const response: IResponse<undefined> = {
                status: EStatuses.NOT_OK,
                message: error.message,
                result: undefined
            }
            return response
        }
    }

    public deleteCommentById = async (id: string): Promise<IResponse<IComment | undefined>> => {
        try {
            const response = await instance.delete(`/comments/${id}`)
            return response.data
        } catch(err: unknown) {
            const error = err as Error
            const response: IResponse<undefined> = {
                status: EStatuses.NOT_OK,
                result: undefined,
                message: error.message
            }
            return response
        }
    }
}

export const commentsApi = new CommentApi()