import React from 'react';
import {BrowserRouter, Routes, Route} from 'react-router-dom';
import Layout from './components/Layout';
import HomePage from './containers/HomePage';
import Login from './containers/Login';
import CreatePost from './components/CreatePost/CreatePost';
import DetailsPost from './containers/DetailsPost/DetailsPost';

const App: React.FunctionComponent = (): React.ReactElement => {
	return (
		<BrowserRouter>
			<Routes>
				<Route path="/" element={<Layout />}>
					<Route index element={<HomePage />} />
					<Route path="register" element={<Login />} />
					<Route path="/posts/:id" element={<DetailsPost />}  />
					<Route path="create" element={<CreatePost />} />
				</Route>
			</Routes>
		</BrowserRouter>
	);
};

export default App;
