import IPost from "../interfaces/IPost"
import IPostDto from "../interfaces/IPostDto"
import IResponse from "../interfaces/IResponse"
import { Mongo, mongo } from "../repository/mongoose"

export class PostService {
    private repository : Mongo
        constructor() {
            this.repository = mongo
        }
        public getPosts = async (): Promise<IResponse<IPost[] | undefined>> => {
            return await this.repository.getPosts()
        }
      
        public getPostById = async (id: string): Promise<IResponse<IPost | undefined>> => {
            return await this.repository.getPostById(id)
        }
      
        public addPost = async (postDto: IPostDto): Promise<IResponse<IPost | undefined>> => {
            return await this.repository.addPost(postDto)
        }
      
        public deletePostById = async (id: string): Promise<IResponse<IPost | undefined>> => {
            return await this.repository.deletePostById(id)
        } 
       
}

export const postService = new PostService()