import IComment from "../interfaces/IComment"
import ICommentDto from "../interfaces/ICommentDto"
import IResponse from "../interfaces/IResponse"
import IUser from "../interfaces/IUser"
import { Mongo, mongo } from "../repository/mongoose"

export class CommentService {
    private repository : Mongo
        constructor() {
            this.repository = mongo
        }
        public getComments = async (): Promise<IResponse<IComment[] | undefined>> => {
            return await this.repository.getComments()
        }
      
        public getCommentById = async (id: string): Promise<IResponse<IComment | undefined>> => {
            return await this.repository.getCommentById(id)
        }

        public getCommentByPost = async (id: string): Promise<IResponse<IComment[] | undefined>> => {
            return await this.repository.getCommentByPost(id)
        }
      
        public addComment = async (commentDto: ICommentDto): Promise<IResponse<IComment | undefined>> => {
            return await this.repository.addComment(commentDto)
        }
      
        public deleteCommentById = async (user: IUser, id: string): Promise<IResponse<IComment | undefined>> => {
            return await this.repository.deleteCommentById(user, id)
        } 
       
}

export const commentService = new CommentService()