import { object, string, TypeOf, } from 'zod';

export const PostSchema = object({
    body: object({
        title: string({
            required_error: 'Title is required',
        }),
        description: string().optional(),
        image: string().optional(),
    }).refine((data) => {
        if (!data.description || !data.image) {
            throw new Error('At least one of description or image is required');
        }
        if (data.description && data.image) {
            return {
                description: data.description,
                image: data.image,
            };
        }
        return true;
    })
})

export type PostInput = TypeOf<typeof PostSchema>['body'];
