import {Router, Request, Response} from 'express';
import * as userController from '../controllers/user';
import UserModel from '../models/User';

const router: Router = Router();

router.post('/register', userController.registerOne);
router.post('/login', userController.loginOne);

router.post('/getToken', async (req: Request, res: Response) => {
	const user = await UserModel.find({token: req.body.token});
	res.send(user);
});

export {router as UsersRouter};
