import mongoose, {Schema} from 'mongoose';
import IPost from '../interfaces/IPost';

const PostsSchema: Schema = new Schema<IPost>(
	{
		title: {
			type: String,
			required: true,
		},
		description: {
			type: String,
		},
		image: {
			type: String,
		},
		datetime: {
			type: Date,
			default: Date.now,
			required: true,
		},
		user: {
			type: Schema.Types.ObjectId,
			required: true,
		},
	},
	{
		versionKey: false,
	}
);

export const Post = mongoose.model<IPost>('Post', PostsSchema);
