import mongoose, { Schema } from "mongoose";
import IComment from "../interfaces/IComment";

const CommentSchema: Schema = new Schema<IComment>({
    comment: {
        type: String,
        required: true
    },   
    datetime: {
        type: Date,
        default: Date.now,
    },
    user: [
        {
            type: Schema.Types.ObjectId,
            ref: 'User'
        }
    ],
    post: [
        {
            type: Schema.Types.ObjectId,
            ref: 'Post'
        }
    ],
    
}, {
    versionKey: false
})

export const Comment = mongoose.model<IComment>('Comment', CommentSchema)