import jwt, {Secret, JwtPayload} from 'jsonwebtoken';
import {Request, Response, NextFunction} from 'express';

export const SECRET_KEY: Secret =
	'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkFsZW4gQm9sYXRvdiIsImlhdCI6MTUxNjIzOTAyMn0.d2_x9z4HZivq8qQUvKEhgROH_zLKwV82bC0a0hXaIvY';

export interface CustomRequest extends Request {
	token: string | JwtPayload;
}

export const auth = async (req: Request, res: Response, next: NextFunction) => {
	try {
		const token = req.header('Authorization')?.replace('Bearer ', '');
		if (!token) {
			throw new Error();
		}

		const decoded = jwt.verify(token, SECRET_KEY);
		(req as CustomRequest).token = decoded;

		next();
	} catch (err) {
		res.status(401).send('Please authenticate');
	}
};
