import express, {Express, json, urlencoded} from 'express';
import 'dotenv/config';
import cors from 'cors';
import {mongo} from './repository/mongoose';
import {UsersRouter} from './routes/user';
import { CommentController } from './controllers/comments';
import { PostsController } from './controllers/posts';


class App {
    private app: Express
    constructor() {
        this.app = express()
        this.app.use(express.json())
        this.app.use(express.static('public'))
        this.app.use(express.urlencoded({extended: true}));
        this.app.use(cors())
    }

    public init = async (): Promise<void> => {
        try {
            await mongo.init()
            process.on('exit', () => {
                mongo.close()
            })
			this.app.use('/posts', new PostsController().getRouter())
			this.app.use('/users', UsersRouter)
			this.app.use('/comments', new CommentController().getRouter())
            this.app.listen(process.env.PORT, () => {
                console.log(`Server is running on port ${process.env.PORT}`)
            })
        } catch(err: unknown) {
            console.log(err)
        }
    }
}

const app = new App()
app.init()