import express, { Router, Request, Response } from 'express'
import { CommentService, commentService } from '../services/comments'
import IUser from '../interfaces/IUser'


export class CommentController {
    private router: Router
    private service: CommentService

    constructor() {
        this.router = express.Router()
        this.service = commentService
        this.router.get('/', this.getComments)
        this.router.get('/:id', this.getCommentById)
        this.router.post('/', this.addComment)
        this.router.delete('/:id', this.deleteCommentById)
    }

    public getRouter = (): Router => {
        return this.router
    }
    private getComments = async (req: Request, res: Response): Promise<void> => {
        if(req.query.post_id) {
            //@ts-ignore
            const response = await this.service.getCommentByPost(req.query.post_id)
            res.send(response)
        } else {
            const response = await this.service.getComments()
            res.send(response)
        }  
    }

    private getCommentById = async (req: Request, res: Response): Promise<void> => {
        const response = await this.service.getCommentById(req.params.id)
        res.send(response)
    }

    private addComment = async (req: Request, res: Response): Promise<void> => {
        const response = await this.service.addComment(req.body)
        res.send(response)
    }

    private deleteCommentById = async (req: Request, res: Response): Promise<void> => {
        const user = req.body._id;
        const id = req.params.id;
        const response = await this.service.deleteCommentById(user,id)
        res.send(response)
    }
}