from http.client import HTTPException

from django.shortcuts import redirect
from rest_framework.renderers import TemplateHTMLRenderer
from rest_framework.response import Response
from rest_framework.views import APIView

from api.serializers import DocumentNDASerializer
from api.services import send_docusign_email


def index_view(request):
    return redirect('send_email')


class SendDocumentView(APIView):
    renderer_classes = [TemplateHTMLRenderer]
    template_name = 'index.html'

    def get(self, request):
        return Response(template_name=self.template_name, status=200)

    def post(self, request):
        serializer = DocumentNDASerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            try:
                send_docusign_email()
                return Response(status=200, data=serializer.data)
            except HTTPException as e:
                return Response({'error': e}, status=503)
        return Response({'error': 'Bad Request'}, status=400)
