import sys
from docusign_esign import ApiClient, ApiException

from api.jwt_console import get_consent_url, get_token
from api.docusign_app.jwt_helpers import get_private_key
from api.models import DocumentNDA
from api.docusign_app.jwt_config import DS_JWT
from api.docusign_app.eSignature.examples.eg002_signing_via_email import Eg002SigningViaEmailController


def get_args(api_account_id, access_token, base_path):
    document = DocumentNDA.objects.last()
    signer_email = document.owner_email
    signer_name = document.owner_name
    cc_email = 'example@mail.com'
    cc_name = 'name'

    envelope_args = {
        "signer_email": signer_email,
        "signer_name": signer_name,
        "cc_email": cc_email,
        "cc_name": cc_name,
        "status": "sent",
    }
    args = {
        "account_id": api_account_id,
        "base_path": base_path,
        "access_token": access_token,
        "envelope_args": envelope_args
    }

    return args


def run_docusign(private_key, api_client):
    jwt_values = get_token(private_key, api_client)
    args = get_args(jwt_values["api_account_id"], jwt_values["access_token"], jwt_values["base_path"])
    envelope_id = Eg002SigningViaEmailController.worker(args, DS_JWT["doc_docx"], DS_JWT["doc_pdf"])
    print("Your envelope has been sent.")
    print(envelope_id)


def send_docusign_email():
    api_client = ApiClient()
    api_client.set_base_path(DS_JWT["authorization_server"])
    api_client.set_oauth_host_name(DS_JWT["authorization_server"])

    private_key = get_private_key(DS_JWT["private_key_file"]).encode("ascii").decode("utf-8")

    try:
        run_docusign(private_key, api_client)
    except ApiException as err:
        body = err.body.decode('utf8')

        if "consent_required" in body:
            consent_url = get_consent_url()
            print("Open the following URL in your browser to grant consent to the application:")
            print(consent_url)
            consent_granted = input("Consent granted? Select one of the following: \n 1)Yes \n 2)No \n")
            if consent_granted == "1":
                run_docusign(private_key, api_client)
            else:
                sys.exit("Please grant consent")

    return {'status': 'success'}
