from django.core.files.storage import FileSystemStorage
from django.db import models

from core import settings


class StatusChoices(models.TextChoices):
    PENDING = 'Документ в обработке'
    RESOLVE = 'Документ успешно подписан'
    REJECT = 'Не удалось подписать документ'
    DEFAULT = 'Документ ожидает подтверждения отправки на подпись'


class DocumentNDA(models.Model):
    owner_name = models.CharField(
        max_length=20,
        null=False,
        blank=False,
        verbose_name='Имя',
    )
    owner_surname = models.CharField(
        max_length=20,
        null=False,
        blank=False,
        verbose_name='Фамилия',
    )
    owner_email = models.EmailField(
        max_length=254,
        verbose_name='Почта',
    )
    source = models.FileField(
        storage=FileSystemStorage(
            location=settings.MEDIA_ROOT,
        ),
        default='settings.MEDIA_ROOT/document.docx',
        upload_to='demo',
        blank=True,
        null=True,
        verbose_name='Исходник',
    )
    status = models.CharField(
        max_length=50,
        null=False,
        blank=False,
        choices=StatusChoices.choices,
        default=StatusChoices.DEFAULT,
        verbose_name='Статус заявки',
    )

    def __str__(self):
        return f'{self.owner_name}  {self.owner_email}'
