import {IMessage, IMessages} from "@/interfaces/IMessages.interface";
import {randomUUID} from "crypto";
import {readFileSync, writeFileSync} from "node:fs";
import path from 'path'

export class MessagesService {
  private filePath: string;
  private messages: IMessages[] = [];

  constructor() {
    this.filePath = path.resolve(__dirname,   `../../data/messages.json`);
    this.restore()
  }

  public getAllMessages = (): IMessages[] => {
    return this.messages.length > 30 ? this.messages.slice(-30) : this.messages
  };

  public createMessages = (data: IMessage): IMessages | undefined => {
    const message = {
      id: randomUUID(),
      message: data.message,
      author: data.author,
      datetime: new Date()
    };
    this.messages.push(message);
    this.save()
    return message
  };
  public getMessage = (date: string): IMessage[] =>{
    console.log(new Date(date), new Date(this.messages[this.messages.length-1].datetime))
    if (new Date(date).getTime() !== new Date(this.messages[this.messages.length-1].datetime).getTime()){
      return this.messages.length > 30 ? this.messages.slice(-30) : this.messages
    }else{
      return []
    }
  }

  private restore = () =>{
    try {
      const saveData = readFileSync(this.filePath, {encoding: "utf-8"});
      this.messages = JSON.parse(saveData)

    }catch (e: any){
      console.log(e)
    }
  }
  private save = () =>{
    writeFileSync(this.filePath,  JSON.stringify(this.messages), {encoding: "utf-8"})
  }
}
