import { Router } from 'express';
import { MessagesController } from '../controllers/messages.controller';
import { IRoute } from '../interfaces/IRoute.interface';
import {createMessageValidator} from "@/middlewares/createMessageValidator";
import {getMessageValidator} from "@/middlewares/getMessageValidator";

export class MessagesRoute implements IRoute {
  public path = '/messages';
  public router = Router();
  private controller: MessagesController;

  constructor() {
    this.controller = new MessagesController();
    this.init();
  }

  private init() {
    this.router.post('/', createMessageValidator(), this.controller.createMessages);
    this.router.get('/', this.controller.getAllMessages);
    this.router.get('/:date', getMessageValidator(), this.controller.getMessage);
  }
}
