import { RequestHandler } from 'express';
import {MessagesService} from "@/services/messages.service";
export class MessagesController {
  private service: MessagesService;

  constructor() {
    this.service = new MessagesService();
  }
  getMessage: RequestHandler = (req,res,next) =>{
    try {
      const message = this.service.getMessage(req.params.date)
      if(message){
        res.send(message)
      }else{
        res.status(400).send({
          "error": "error date"
        })
      }
    }catch (e){
      next()
    }
  }
  getAllMessages: RequestHandler = (req, res, next): void => {
    try {
      const articles = this.service.getAllMessages();
      res.send(articles);
    }
    catch (e){
      next(e)
    }
  };

  createMessages: RequestHandler = (req, res): void => {
    const messages = this.service.createMessages(req.body)
    res.send(messages);
  };
}
