import express from 'express';
import { Application, RequestHandler } from 'express';
import { AppInit } from './interfaces/AppInit.interface';
import { IRoute } from './interfaces/IRoute.interface';
import {errorHandler} from "@/middlewares/errorHandler";

class App {
  public app: Application;
  public port: number;
  constructor(appInit: AppInit) {
    this.app = express();
    this.port = appInit.port;

    this.initAssets();
    this.initMiddlewares(appInit.middlewares);
    this.initRoutes(appInit.controllers);
    this.initErrorHandler()
  }
  private initMiddlewares(middlewares: RequestHandler[]) {
    middlewares.forEach((middleware) => {
      this.app.use(middleware);
    });
  }
  private initErrorHandler = () =>{
    this.app.use('*', (req, res)=>{
      res.status(404).send({
        success: false,
        messages: 'Resource not found'
      })
    })
    this.app.use(errorHandler())
  }
  private initRoutes(routes: IRoute[]) {
    routes.forEach((route) => {
      this.app.use(route.path, route.router);
    });
  }
  private initAssets() {
    this.app.use(express.json());
  }
  public listen() {
    this.app.listen(this.port, () => {
      console.log(`App listening  on the http://localhost:${this.port}`);
    });
  }
}

export default App;
