import { EStatuses } from "../enums/EStatuses"
import IProduct from "../interfaces/IProduct"
import IProductDto from "../interfaces/IProductDto"
import IResponse from "../interfaces/IResponse"
import { Product } from "../models/Product"
import { Op } from 'sequelize'

export class ProductServicePg {
    public getProducts = async (): Promise<IResponse> => {
        try {
            const data = await Product.findAll()
            // {
            //     where: {
            //         title:  {
            //             [Op.like]: '%App%'
            //         }
            //     }
            // }
            const response: IResponse = {
                status: EStatuses.OK,
                result: data,
                message: 'Products found'
            }
            return response
        } catch (err: unknown) {
            const error = err as Error
            const response: IResponse = {
                status: EStatuses.NOT_OK,
                result: undefined,
                message: error.message
            }
            return response
        }
    }

    public getProductById = async (id: string): Promise<IResponse> => {
        try {
            const data: IProduct | null = await Product.findByPk(id)
            const response: IResponse = {
                status: EStatuses.OK,
                result: data,
                message: ''
            }
            return response
        } catch (err: unknown) {
            const error = err as Error
            const response: IResponse = {
                status: EStatuses.NOT_OK,
                result: undefined,
                message: error.message
            }
            return response
        }
    }

    public addProduct = async (product: IProductDto): Promise<IResponse> => {
        try {
            const data: IProduct | undefined = await Product.create({...product})
            const response: IResponse = {
                status: EStatuses.OK,
                result: data,
                message: ''
            }
            return response
        } catch (err: unknown) {
            const error = err as Error
            const response: IResponse = {
                status: EStatuses.NOT_OK,
                result: undefined,
                message: error.message
            }
            return response
        }
    }

}

export const productServicePg = new ProductServicePg()