import { EStatuses } from "../enums/EStatuses"
import IProduct from "../interfaces/IProduct"
import IRequest from "../interfaces/IRequest"
import IResponse from "../interfaces/IResponse"
import { db } from "../repository/fileDB"

class ProductService {
    getProducts = (): IResponse => {
        try {
            const data = db.getItems()
            const response: IResponse = {
                status: EStatuses.OK,
                result: data,
                message: ''
            }
            return response
        } catch (err: unknown) {
            const error = err as Error
            const response: IResponse = {
                status: EStatuses.NOT_OK,
                result: undefined,
                message: error.message
            }
            return response
        }
    }

    getProductById = (id: string): IResponse => {
        try {
            const data: IProduct | undefined = db.getItemById(id)
            const response: IResponse = {
                status: EStatuses.OK,
                result: data,
                message: ''
            }
            return response
        } catch (err: unknown) {
            const error = err as Error
            const response: IResponse = {
                status: EStatuses.NOT_OK,
                result: undefined,
                message: error.message
            }
            return response
        }
    }

    addProduct = (product: IRequest): IResponse => {
        try {
            const data: IProduct | undefined = db.addItem(product)
            const response: IResponse = {
                status: EStatuses.OK,
                result: data,
                message: ''
            }
            return response
        } catch (err: unknown) {
            const error = err as Error
            const response: IResponse = {
                status: EStatuses.NOT_OK,
                result: undefined,
                message: error.message
            }
            return response
        }
    }

}

export const productService = new ProductService()