import IProduct from "../interfaces/IProduct";
import fs from 'node:fs/promises'
import { uuid } from 'uuidv4';
import IRequest from "../interfaces/IRequest";

class FileDB {
    data: IProduct[]
    filename: string
    constructor() {
        this.data = []
        this.filename = './db.json'
    }
    init = async () => {
        try {
          const fileContents = await fs.readFile(this.filename, {encoding: 'utf-8'});
          this.data = JSON.parse(fileContents);
        } catch (err) {
          const error = err as Error
          console.log(error.message)
          this.data = [];
          await fs.writeFile('./db.json', JSON.stringify(this.data), {encoding: 'utf-8'})
        }
      }

      getItems = () => {
        return this.data;
      }

      getItemById = (id: string) => {
        return this.data.find(p => p.id === id);
      }
     
      addItem = (item: IRequest): IProduct => {
        const id: string = uuid()
        const product: IProduct = {...item, id}
        this.data.push(product);
        this.save();
        return product
      }
    
      save = async () => {
        try {
            await fs.writeFile(this.filename, JSON.stringify(this.data));
        } catch(err: unknown) {
            const error = err as Error
            console.log(error.message)
        }
      }
}

export const db = new FileDB()