import express, { Express } from 'express'
import { config } from './index.config'
import { healthCheckRouter } from './controllers/healthCheck'
import { productsRouter } from './controllers/products'
import { db } from './repository/fileDB'

const app: Express = express()
app.use(express.json())

const run = async () => {
    db.init()
    app.use('/health-check', healthCheckRouter)
    app.use('/products', productsRouter)
    app.listen(config.port, () => {
        console.log(`Server is running on port ${config.port}`)
    })
}

run()
.then(() => {
    console.log('Everything is ok')
})
.catch((err: unknown) => {
    const error = err as Error
    console.log(error.message)
})