import express, { Router, Request, Response } from 'express'
import { productService } from '../services/products'

const router: Router = express.Router()

router.get('/', (req: Request, res: Response) => {
    const response = productService.getProducts()
    res.send(response)
})

router.get('/:id', (req: Request, res: Response) => {
    const response = productService.getProductById(req.params.id)
    res.send(response)
})

router.post('/', (req: Request, res: Response) => {
    const response = productService.addProduct(req.body)
    res.send(response)
})

export const productsRouter = router