import express, { Router, Request, Response } from 'express'
import { EStatuses } from '../enums/EStatuses'
import IResponse from '../interfaces/IResponse'

const router: Router = express.Router()

router.get('/', (req: Request, res: Response) => {
    try {
        const response: IResponse = {
            status: EStatuses.OK,
            result: undefined,
            message: 'Server is ok'
        }
        res.send(response)
    } catch (err: unknown) {
        const error = err as Error
        const response: IResponse = {
            status: EStatuses.NOT_OK,
            result: undefined,
            message: error.message
        }
        res.status(200).send(response)
    }
})

export const healthCheckRouter = router