from django.shortcuts import render
from django.urls import reverse, reverse_lazy
from django.views import View
from django.views.generic import CreateView, DetailView, UpdateView, DeleteView

from webapp.forms import EventForm
from webapp.models import Event


def index_view(request):
    return render(request, "index.html")


class EventView(View):
    def get(self, request, *args, **kwargs):
        events = Event.objects.all()
        context = {"events": events}
        return render(request, "event_list.html", context)


class EventCreateView(CreateView):
    model = Event
    template_name = "event_create.html"
    form_class = EventForm

    def get_success_url(self):
        return reverse("detail_events", kwargs={"pk": self.object.pk})


class EventDetailView(DetailView):
    model = Event
    template_name = "event_detail.html"
    context_object_name = "event"


class EventUpdateView(UpdateView):
    model = Event
    template_name = "event_update.html"
    form_class = EventForm

    def get_success_url(self):
        return reverse("detail_events", kwargs={"pk": self.object.pk})


class EventDeleteView(DeleteView):
    model = Event
    template_name = "event_delete.html"
    success_url = reverse_lazy("list_events")






