from django.db import models


class Restaurant(models.Model):
    name = models.CharField(max_length=30, verbose_name="Название заведения")

    address = models.CharField(max_length=70, verbose_name="Адрес")

    photo = models.ImageField(upload_to="photo", default=1, verbose_name="Фото заведения")

    description = models.TextField(max_length=1000, verbose_name="Описание заведения")

    def __str__(self):
        return f'{self.name}'


class Event(models.Model):
    place = models.ForeignKey(Restaurant, on_delete=models.CASCADE,
                              verbose_name="Место проведения", related_name="Place")

    date = models.DateTimeField(verbose_name="Дата")

    def __str__(self):
        return f'{self.place} - {self.date}'



