"""speed_dating URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.urls import path
from webapp import views as webapp_views

urlpatterns = [
    path('admin/', admin.site.urls),
    path("", webapp_views.index_view, name="index"),
    path("events/", webapp_views.EventView.as_view(), name="list_events"),
    path("events/create/", webapp_views.EventCreateView.as_view(), name="create_events"),
    path("events/<int:pk>/", webapp_views.EventDetailView.as_view(), name="detail_events"),
    path("events/<int:pk>/edit/", webapp_views.EventUpdateView.as_view(), name="update_events"),
    path("events/<int:pk>/delete/", webapp_views.EventDeleteView.as_view(), name="delete_events")
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
