#!/usr/bin/env bash

echo "================================"
echo "<===== Run create-deployment-package.sh ====>"
echo "================================"

set -e

BRANCH=${1}
VERSION=${2}
ENV_NAME=.env.example

info() {
    echo -e "\e[33m[Info]     \e[33m$1 \e[39m"
}

success() {
    echo -e "\e[32m[Success] \e[32m $1 \e[39m"
}
info "Build version #${VERSION}"
info "./build.sh starts here..."

info "build started under user $(whoami)"

info "Clear all cache"
php artisan cache:clear
php artisan view:clear
php artisan config:clear

info "Install environment for server ${BRANCH}"

cp ${ENV_NAME} .env

info "Install requirements"
composer install --no-interaction --prefer-dist

info "Generate application key"
php artisan key:generate

info "Create directory 'artifacts' if not exists"
mkdir -p ${HOME}/artifacts

info "Create application artifact for version: ${VERSION}"
tar -czf ${HOME}/artifacts/application-${VERSION}.tar.gz \
--exclude=README.md \
--exclude=tests \
.

ls ${HOME}/artifacts/

success "Create package completed!"
