#!/usr/bin/env bash

set -e


info() {
echo -e "\e[33m [Info]     \e[33m$1 \e[39m"
}


success() {
echo -e "\e[32m [Success] \e[32m $1 \e[39m"
}

info "build started under user $(whoami)"


info "Install environment for unit tests"
cp .env.unit .env


info "Install requirements >>>>> "
composer install --no-interaction --prefer-dist


info "Generate application key >>>>>> "
php artisan key:generate


info "Start unit test >>>>> "
php artisan test


info "Setup environment for dusk test"
cp .env.dusk .env


echo "Make database for testing ${pwd}"


php artisan key:generate
php artisan dusk:chrome-driver
nohup bash -c "php artisan serve --env=dusk --port=4343 2>&1 &" && sleep 5
php artisan dusk


success "Completed testing!"
